/* 
 * cosine.c 
 *
 * Обчислює cos(2.0) і виводить результат.
 * Ілюструє порядок підключення динамічних бібліотек за потребою.
 *
 */

#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv) 
{
        void *handle;
        double (*cosine)(double);
        char *error;

        /* Завантажує/відкриває бібліотеку libm.so. */
        handle = dlopen("libm.so", RTLD_LAZY);
        if (handle == NULL) {
                /* Невдача */
                fprintf(stderr, "Error opening libm.so: %s\n", dlerror());
                exit(EXIT_FAILURE);
        }
        /* Очищає ідентифікатор помилки. */
        dlerror();
        /* Знаходить в бібліотеці libm.so (заданій покажчиком handle)
           функцію cos() і зберігає покажчик на неї в змінній cosine. */
        *(void **) (&cosine) = dlsym(handle, "cos");
        /* Останній рядок буде зрозумілішим, якщо його переписати так:
        cosine = (double (*)(double)) dlsym(handle, "cos");
         */
        error = dlerror();
        if (error != NULL)  {
                /* Виникла якась помилка. */
                fprintf(stderr, "Error accessing to libm.so: %s\n", error);
                exit(EXIT_FAILURE);
        }
        /* Обчислює cos(2.0) і виводить результат. */
        printf("%f\n", (*cosine)(2.0));
        /* Закриває/вивантажує бібліотеку libm.so. */
        dlclose(handle);
        exit(EXIT_SUCCESS);
}
